/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import panther.util.general.ErrorUtils;
import panther.util.general.OpsOut;
import panther.util.resource.Resource;
import panther.util.resource.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtil {
    private static final Logger logger = Logger.getLogger(DBUtil.class.getName());
    private static ColumnConverter defaultConverter = new ColumnConverter(){

        public Object getColumnValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getObject(n);
        }
    };
    public static final int IN_CLAUSE_LIMIT = 250;

    public static String getDbProductName(Connection connection) {
        Object object;
        if (connection instanceof Resource) {
            object = (Connection)Resources.dangerousGetUnderlyingResource(connection);
            if (object == null) {
                throw new Error("Unable to get underlying connection for : " + connection);
            }
            connection = object;
        }
        if (connection == null) {
            throw new Error("Unable to determine db-product, connection is null");
        }
        object = connection.getClass().getPackage().getName().toLowerCase();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("db product test on: connection-type=" + connection.getClass().getName() + ",connection-package=" + (String)object);
        }
        if (((String)object).indexOf("oracle") >= 0) {
            return "oracle";
        }
        if (((String)object).indexOf("postgresql") >= 0) {
            return "postgresql";
        }
        if (((String)object).indexOf("microsoft") >= 0 || ((String)object).indexOf("sqlserver") >= 0 || ((String)object).indexOf("datadirect") >= 0) {
            return "microsoft";
        }
        logger.warning("db product test FAILED on: " + (String)object);
        return "unknown";
    }

    public static Map<String, String> map(Connection connection, String string) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DBUtil.mapInto(hashMap, connection, string);
        return hashMap;
    }

    public static Map<String, String> map(Connection connection, String string, String string2, List<Object> list) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DBUtil.mapInto(hashMap, connection, string, string2, list);
        return hashMap;
    }

    public static void mapInto(Map<String, String> map, Connection connection, String string) throws Exception {
        List list;
        if (connection != null && (list = DBUtil.executeQuery(connection, string)) != null) {
            for (int i = 0; i < list.size(); ++i) {
                List list2 = (List)list.get(i);
                String string2 = String.valueOf(list2.get(0));
                String string3 = String.valueOf(list2.get(1));
                map.put(string2, string3);
            }
        }
    }

    public static void mapInto(Map<String, String> map, Connection connection, String string, String string2, List<Object> list) throws Exception {
        List list2;
        if (connection != null && (list2 = DBUtil.executeInQuery(connection, string, string2, list)) != null) {
            for (int i = 0; i < list2.size(); ++i) {
                List list3 = (List)list2.get(i);
                String string3 = String.valueOf(list3.get(0));
                String string4 = String.valueOf(list3.get(1));
                map.put(string3, string4);
            }
        }
    }

    public static Object queryDatum(Connection connection, String string) throws SQLException {
        List list = DBUtil.queryUnique(connection, string);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public static Object queryDatum(Connection connection, String string, Object object) throws SQLException {
        List list = DBUtil.queryUnique(connection, string, object);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public static Object queryDatum(Connection connection, String string, List list) throws SQLException {
        List list2 = DBUtil.queryUnique(connection, string, list);
        return list2 == null || list2.size() == 0 ? null : list2.get(0);
    }

    public static List queryUnique(Connection connection, String string) throws SQLException {
        return DBUtil.singleSelect(connection, string);
    }

    public static List queryUnique(Connection connection, String string, Object object) throws SQLException {
        return DBUtil.singleSelect(connection, string, object);
    }

    public static List queryUnique(Connection connection, String string, List list) throws SQLException {
        return DBUtil.singleSelect(connection, string, list);
    }

    public static List singleSelect(Connection connection, String string) throws SQLException {
        List list = DBUtil.executeQuery(connection, string);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (List)list.get(0);
        }
        throw new Error("Multiple results in singleSelect");
    }

    public static List singleSelect(Connection connection, String string, Object object) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(object);
        return DBUtil.singleSelect(connection, string, arrayList);
    }

    public static List singleSelect(Connection connection, String string, List list) throws SQLException {
        List list2 = DBUtil.executeQuery(connection, string, list);
        if (list2.size() == 0) {
            return null;
        }
        if (list2.size() == 1) {
            return (List)list2.get(0);
        }
        throw new Error("Multiple results in singleSelect");
    }

    public static List executeQuery(Connection connection, String string) throws SQLException {
        return DBUtil.executeQuery(connection, string, new ArrayList());
    }

    public static List executeQuery(Connection connection, String string, int n) throws SQLException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        arrayList.add(new Integer(n));
        return DBUtil.executeQuery(connection, string, arrayList);
    }

    public static List executeQuery(Connection connection, String string, Object object) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(object);
        return DBUtil.executeQuery(connection, string, arrayList);
    }

    public static List executeQuery(Connection connection, String string, List list) throws SQLException {
        return DBUtil.executeQuery(connection, string, list, defaultConverter);
    }

    public static List executeQuery(Connection connection, String string, List list, ColumnConverter columnConverter) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            preparedStatement = connection.prepareStatement(string);
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object instanceof Date) {
                    Timestamp timestamp = new Timestamp(((Date)object).getTime());
                    object = timestamp;
                }
                preparedStatement.setObject(i + 1, object);
            }
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                object = new ArrayList();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    object.add((Object)columnConverter.getColumnValue(resultSet, i));
                }
                arrayList.add(object);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                DBUtil.safeClose(resultSet, preparedStatement);
                throw throwable;
            }
        }
        DBUtil.safeClose(resultSet, preparedStatement);
        return arrayList;
    }

    public static int executeUpdate(Connection connection, String string) throws SQLException {
        return DBUtil.executeUpdate(connection, string, new ArrayList());
    }

    public static int executeUpdate(Connection connection, String string, int n) throws SQLException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        arrayList.add(new Integer(n));
        return DBUtil.executeUpdate(connection, string, arrayList);
    }

    public static int executeUpdate(Connection connection, String string, Object object) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(object);
        return DBUtil.executeUpdate(connection, string, arrayList);
    }

    public static int executeUpdate(Connection connection, String string, List list) throws SQLException {
        PreparedStatement preparedStatement = null;
        int n = -1;
        int n2 = -1;
        try {
            preparedStatement = connection.prepareStatement(string);
            for (int i = 0; i < list.size(); ++i) {
                n2 = i;
                Object e = list.get(i);
                if (e instanceof Date) {
                    preparedStatement.setTimestamp(i + 1, new Timestamp(((Date)e).getTime()));
                    continue;
                }
                preparedStatement.setObject(i + 1, list.get(i));
            }
            n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            OpsOut.println("inputs = " + list + ", place = " + n2);
            throw sQLException;
        }
        finally {
            DBUtil.safeClose(preparedStatement);
        }
        return n;
    }

    public static List executeInQuery(Connection connection, String string, String string2, List list) throws SQLException {
        int n;
        if (list == null || list.isEmpty()) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); i += n) {
            n = Math.min(250, list.size() - i);
            String string3 = string + string2 + " IN " + DBUtil.buildInClause(n);
            List list2 = null;
            try {
                list2 = DBUtil.executeQuery(connection, string3, list.subList(i, i + n));
            }
            catch (SQLException sQLException) {
                System.out.println("\n\nbaseSQL=" + string + "\nkey=" + string2 + "\nsql = " + string3 + "\ninputs = " + list.subList(i, i + n) + "\n\n");
                throw sQLException;
            }
            catch (Throwable throwable) {
                System.out.println("\n\nbaseSQL=" + string + "\nkey=" + string2 + "\nsql = " + string3 + "\ninputs = " + list.subList(i, i + n) + "\n\n");
                throw new Error(throwable);
            }
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static List executeInQuery(Connection connection, String string, String string2, List list, Object object) throws SQLException {
        int n;
        if (list == null || list.isEmpty()) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); i += n) {
            n = Math.min(250, list.size() - i);
            String string3 = string + string2 + " IN " + DBUtil.buildInClause(n);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(object);
            arrayList2.addAll(list.subList(i, i + n));
            List list2 = DBUtil.executeQuery(connection, string3, arrayList2);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static int executeInUpdate(Connection connection, String string, String string2, List list) throws SQLException {
        int n;
        if (list == null || list.isEmpty()) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < list.size(); i += n) {
            n = Math.min(250, list.size() - i);
            String string3 = string + string2 + " IN " + DBUtil.buildInClause(n);
            int n3 = DBUtil.executeUpdate(connection, string3, list.subList(i, i + n));
            n2 += n3;
        }
        return n2;
    }

    public static int executeInUpdate(Connection connection, String string, String string2, List list, List list2) throws SQLException {
        int n;
        if (list == null || list.isEmpty()) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < list.size(); i += n) {
            n = Math.min(250, list.size() - i);
            String string3 = string + string2 + " IN " + DBUtil.buildInClause(n);
            ArrayList arrayList = new ArrayList(list2);
            arrayList.addAll(list.subList(i, i + n));
            int n3 = DBUtil.executeUpdate(connection, string3, arrayList);
            n2 += n3;
        }
        return n2;
    }

    public static String buildInClause(int n) {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("?");
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public static boolean safeRollback(Connection connection) {
        if (connection == null) {
            return true;
        }
        try {
            connection.rollback();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return false;
        }
        return true;
    }

    public static void safeClose(ResultSet resultSet, Statement statement) {
        DBUtil.safeClose(resultSet);
        DBUtil.safeClose(statement);
    }

    public static void safeClose(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ErrorUtils.checkSwallow(sQLException);
        }
    }

    public static void safeClose(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            ErrorUtils.checkSwallow(sQLException);
        }
    }

    public static void safeRelease(Connection connection, String string) {
        block3: {
            if (connection == null) {
                return;
            }
            try {
                Resources.releaseConnection(string, connection);
            }
            catch (Throwable throwable) {
                OpsOut.println("Error releasing Connection");
                OpsOut.trace(throwable);
                if (!(throwable instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)throwable;
            }
        }
    }

    public static void begin(Connection connection, String string) throws SQLException {
        if (DBUtil.isSQLServer(string)) {
            DBUtil.executeUpdate(connection, "begin tran");
        } else if (DBUtil.isPostgres(string)) {
            DBUtil.executeUpdate(connection, "begin");
        }
    }

    public static String forUpdateString(String string) {
        if (DBUtil.isOracle(string)) {
            return "for update";
        }
        if (DBUtil.isPostgres(string)) {
            return "for update";
        }
        return "";
    }

    public static String sequenceNextValString(String string, String string2) {
        if (DBUtil.isOracle(string)) {
            return string2 + ".nextval";
        }
        if (DBUtil.isPostgres(string)) {
            return "nextval('" + string2 + "')";
        }
        return null;
    }

    public static void commit(Connection connection, String string) throws SQLException {
        if (DBUtil.isSQLServer(string)) {
            DBUtil.executeUpdate(connection, "commit");
        }
        connection.commit();
    }

    public static boolean isOracle(String string) {
        return string.equalsIgnoreCase("oracle");
    }

    public static boolean isPostgres(String string) {
        return string.equalsIgnoreCase("postgresql");
    }

    public static boolean isSQLServer(String string) {
        return string.equalsIgnoreCase("sqlserver") || string.equalsIgnoreCase("datadirect") || string.equalsIgnoreCase("microsoft");
    }

    public static interface ColumnConverter {
        public Object getColumnValue(ResultSet var1, int var2) throws SQLException;
    }
}

